
DROP TABLE TMP_DIG001
GO
CREATE TABLE TMP_DIG001 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip6 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO



DROP TABLE DIG001
GO
CREATE TABLE DIG001 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip4 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO

DROP INDEX DIG001.DIG001_IND1 
GO
CREATE UNIQUE INDEX DIG001_IND1 ON DIG001 (ICARD,END_IP)
GO


DROP TABLE DIG002
GO
CREATE TABLE DIG002 (
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip5 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  DATA_LOAD    DATETIME	DEFAULT GETDATE(),
  STATUS	CHAR(1),
  BIO_TIPO 	CHAR(1)
)
GO

DROP INDEX DIG002.DIG002_IND1 
GO
CREATE UNIQUE INDEX DIG002_IND1 ON DIG002 (END_IP)
GO


grant select ON DIG001 TO ACE_USU
grant execute on sqller_comldig to ace_usu
grant execute on sqlload_listadig to ace_usu
grant execute on sqlfim_Ldig to ace_usu
grant execute on sqlapos_datahora2 to ACE_USU
GRANT EXECUTE ON sqlatu_geral2 TO ACE_USU

grant select on DIG002 to ACE_INI
grant execute on p_gerdigital to ACE_INI

--COMPILAR S_ATUGERAL2.SQL
--COMPILAR S_aposDatahora2.sql

