DROP PROCEDURE sqlatu_pendon002_lpz 
GO
CREATE PROCEDURE sqlatu_pendon002_lpz @cTpCarga CHAR(1), @nLivre int, @cEndIp CHAR(15), @nLivreAux int AS

DECLARE @nRet SMALLINT, @cStatus char(1)
DECLARE @ERR INT		

	--SET LOCK_TIMEOUT 3000
	SET NOCOUNT ON
	SET LOCK_TIMEOUT 2000
	SET @nRet = 0
	IF (@cTpCarga = '0') begin 		-- 0 = Lista Limpeza foi carregada
		--begin transaction t1
		UPDATE PEND_ON002LPZ  
			SET STATUS_LPZ = '0'		-- era '3'
			WHERE END_IP = @cEndIp and STATUS_LPZ = '2' 
		set @ERR = @@ERROR

		--begin transaction t2
		UPDATE PEND_ON002ON  
			SET QTD_LIVRE = @nLivre,
				STATUS = '8' 
			WHERE END_IP = @cEndIp 
		set @ERR = @@ERROR

		--begin transaction t3
		UPDATE PEND_ON002OFF  
			SET QTD_LIVREOFF = @nLivreAux,
				STATUS_OFF = '8' 
			WHERE END_IP = @cEndIp 
		set @ERR = @@ERROR
		
	END

	ELSE IF (@cTpCarga = '1') BEGIN		-- 1 = Lista Limpeza nao foi carregada devido a falta de espao
		--begin transaction t4
		UPDATE PEND_ON002LPZ SET STATUS_LPZ = '4'		-- ERA '5'
			WHERE END_IP = @cEndIp -- and STATUS_LPZ = '2' 
		set @ERR = @@ERROR
		
	END

	ELSE IF (@cTpCarga = '2' OR @cTpCarga = '3') BEGIN		-- 2 = Lista Limpeza nao foi carregada devido a outros erros
		--begin transaction t5
		UPDATE PEND_ON002LPZ SET STATUS_LPZ = '4'
			WHERE END_IP = @cEndIp --and STATUS_LPZ = '2' 
		set @ERR = @@ERROR
		
	END
		
		
	SET LOCK_TIMEOUT -1
	SELECT @nRet
	GO

--grant execute on sqlatu_pendon002_lpz to ACE_USU
--GO
