DROP PROCEDURE sqlapos_datahora3
GO
CREATE PROCEDURE sqlapos_datahora3 @cEndIp CHAR(15), @pt_aviso char(250), @nTipo int AS

DECLARE @nRet SMALLINT, @cAviso char(2), @cStat char(1), @cMens char(30), @dData DATETIME
DECLARE @ERR INT


	SET @nRet = 0
	SET NOCOUNT ON
	SET DATEFORMAT DMY


	if (@nTipo = 1 or @nTipo = 3) begin
		set @cAviso = SUBSTRING(@pt_aviso, 16, 2)
		set @cStat  = SUBSTRING(@pt_aviso, 18, 1)
		set @cMens  = SUBSTRING(@pt_aviso, 19,30)
		set @dData = '01-01-01 00:00:00'

		-- resposta de comando 
		if exists (select ST from CP_BN  WHERE AVISO = @cAviso and END_IP = @cEndIp) 
		begin
			UPDATE CP_BN SET ST = @cStat,    
							 EPN3 = @cMens 
			WHERE AVISO = @cAviso AND
				  END_IP = @cEndIp
		end	
		else
		begin
			-- aviso nao existe, sera' inserido novo comando
			INSERT INTO CP_BN (END_IP, AVISO, ST, EPN3) VALUES (@cEndIp, @cAviso, @cStat, @cMens)
		end

		UPDATE DAT07 SET
			ATUFORC = '0',
			DATFORC = @dData
		WHERE END_IP = @cEndIp 

		set lock_timeout 3000
		-- pendencia online
		UPDATE PEND_ON002ON SET
			STATUS = '7',
			QTD_LIVRE = 1
			WHERE END_IP = @cEndIp AND STATUS = '6'

		-- pendencia offline
		UPDATE PEND_ON002OFF SET
			STATUS_OFF = '7',
			QTD_LIVREOFF = 1
		WHERE END_IP = @cEndIp AND STATUS_OFF = '6'

		set lock_timeout -1
	end
	
	-- carga digitais automatica
	if (@nTipo = 2 or @nTipo = 3) begin
		UPDATE DIG002 SET STATUS = '5' 
			WHERE END_IP = @cEndIp AND STATUS = '6'

	end

	
	SELECT @nRet
	GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
