DROP function trunc_data
GO
CREATE function trunc_data  (@d1 as datetime, @tipo as varchar(2)) returns 
datetime
as
begin
declare @hora char(2), @minuto char(2), @segundo char(2), @dia char(2), @mes char(2), @ano char(4),	@cData char(20)
declare  @dDataRes datetime

--set dateformat ymd

SET @segundo = convert(char(2),datepart(second,@d1))
SET @minuto = convert(char(2),datepart(minute,@d1))
SET @hora = convert(char(2),datepart(hour,@d1))
SET @dia = convert(char(2),datepart(day,@d1))
SET @mes = convert(char(2),datepart(month,@d1))
SET @ano = convert(char(4),datepart(year,@d1))

set @cData = @ano+'/'+@mes+'/'+@dia+' '+@hora+':'+@minuto+':'+@segundo

-- ano
if (UPPER(@tipo) = 'YY') 
	set @cData = @ano+'/01/01 00:00:00'

-- mes
else if (UPPER(@tipo) = 'MM') 
	set @cData = @ano+'/'+@mes+'/01 00:00:00'

-- dia
else if (UPPER(@tipo) = 'DD')
	set @cData = @ano+'/'+@mes+'/'+@dia+' 00:00:00'

-- hora	
else if (UPPER(@tipo) = 'HH')
	set @cData = @ano+'/'+@mes+'/'+@dia+' '+@hora+':00:00'

-- minuto
else if (UPPER(@tipo) = 'MI')
	set @cData = @ano+'/'+@mes+'/'+@dia+' '+@hora+':'+@minuto+':00'


set @dDataRes = @cData
return @dDataRes
end