drop procedure sqlsit_coletor
go

CREATE PROCEDURE sqlsit_coletor @cTipo char(1), @pt_sitcolet char(100)
AS

DECLARE @cEndIp char(15), @cData char(12), @cDataSit char(17), @cIdConex char(15), 
		@cDisp char(1), @cBlueB char(2), @cTerm char(2)
BEGIN
		
	Select @cEndIp	 = SUBSTRING(@pt_sitcolet,  1, 15)
	Select @cBlueB	 = SUBSTRING(@pt_sitcolet, 16,  2)
	Select @cTerm	 = SUBSTRING(@pt_sitcolet, 18,  2)
	Select @cIdConex = SUBSTRING(@pt_sitcolet, 20, 15)
	Select @cDisp	 = SUBSTRING(@pt_sitcolet, 35,  1)
	Select @cData	 = SUBSTRING(@pt_sitcolet, 36, 12)

	Select @cDataSit = substring(@cData,1,2)+ '/'+ substring(@cData,3,2)+ '/'+ 
						substring(@cData,5,2)+ ' '+ substring(@cData,7,2)+ ':'+ 
						substring(@cData,9,2)+ ':'+	substring(@cData,11,2)
	Set dateformat dmy

	-- procura na tabela. Se achou, atualiza. Se no achou, insere
	--tipo '1' = codin arl, '2' = codin tcp, tipo '3' = Arlonp, tipo '4' = Conex
	-- codin arl
	IF (@cTipo = '1') 	
		BEGIN
			IF NOT EXISTS (SELECT BLUEB, CODIN from SITCOLETOR 
							WHERE BLUEB = @cBlueB and 
								  CODIN = @cTerm)
				BEGIN
					INSERT INTO SITCOLETOR 
						(ENDIP, BLUEB, CODIN, ID_CONEX, DISPOSITIVO, DT_ATUALI) 
					VALUES 
						(@cEndIp, @cBlueB, @cTerm, @cIdConex, @cDisp, @cDataSit)  
				END
			ELSE
				BEGIN
					UPDATE SITCOLETOR 
					SET DT_ATUALI = @cDataSit,
						ID_CONEX = @cIdConex
					WHERE BLUEB = @cBlueB and
						  CODIN = @cTerm
				END
		END
	-- codin tcp		
	IF (@cTipo = '2')
		BEGIN	
			IF NOT EXISTS (SELECT ENDIP from SITCOLETOR WHERE ENDIP = @cEndIp AND BLUEB = '00' AND CODIN = '00')
				BEGIN
					INSERT INTO SITCOLETOR 
						(ENDIP, BLUEB, CODIN, ID_CONEX, DISPOSITIVO, DT_ATUALI) 
					VALUES 
						(@cEndIp, @cBlueB, @cTerm, @cIdConex, @cDisp, @cDataSit)  
				END
			ELSE
				BEGIN
					UPDATE SITCOLETOR 
					SET DT_ATUALI = @cDataSit,
						ID_CONEX = @cIdConex
					WHERE ENDIP = @cEndIp AND BLUEB = '00' AND CODIN = '00'
				END
		END
	-- arlonp
	IF (@cTipo = '3')
		BEGIN	
			IF NOT EXISTS (SELECT BLUEB, CODIN from SITCOLETOR 
							WHERE BLUEB = @cBlueB and 
								  CODIN = '99')
				BEGIN
					INSERT INTO SITCOLETOR 
						(ENDIP, BLUEB, CODIN, ID_CONEX, DISPOSITIVO, DT_ATUALI) 
					VALUES 
						(@cEndIp, @cBlueB, '99', @cIdConex, @cDisp, @cDataSit)  
				END
			ELSE
				BEGIN
					UPDATE SITCOLETOR 
					SET DT_ATUALI = @cDataSit,
						ID_CONEX = @cIdConex
					WHERE BLUEB = @cBlueB and
						  CODIN = '99'
				END
		END
	-- conex
	IF (@cTipo = '4')
		BEGIN	
			IF NOT EXISTS (SELECT ENDIP from SITCOLETOR 
							WHERE ENDIP = @cEndIp and BLUEB = '00' AND CODIN = '00' and ID_CONEX = @cIdConex)
				BEGIN
					INSERT INTO SITCOLETOR 
						(ENDIP, BLUEB, CODIN, ID_CONEX, DISPOSITIVO, DT_ATUALI) 
					VALUES 
						(@cEndIp, @cBlueB, @cTerm, @cIdConex, @cDisp, @cDataSit)  
				END
			ELSE
				BEGIN
					UPDATE SITCOLETOR 
					SET DT_ATUALI = @cDataSit
						--ID_CONEX = @cIdConex,
						--ENDIP = @cEndIp 
					WHERE ENDIP = @cEndIp and
						  BLUEB = '00' AND
						  CODIN = '00' AND
						  ID_CONEX = @cIdConex
						  
				END
		END
	return (0)
END
GO

