DROP PROCEDURE request_lock 
GO

CREATE PROCEDURE request_lock @cMatric char(12), @cUsuario char(15)
AS

DECLARE @ret int, @dh_lock char(30), @difminuto int
BEGIN
   -- locka matricula se esta nao estiver lockada
   IF NOT EXISTS (SELECT * from TABLOCKS WITH (Index = TABLOCKS_IND1) where ICARD = @cMatric)
   begin
	insert into TABLOCKS values (@cMatric, getdate(), @cUsuario)
	select @ret = 0
   end
   -- se matricula lockada, verifica se o lock tem validade (menos que 2 minutos)
   else
   begin
	select @dh_lock = DATAHORA from TABLOCKS WITH (Index = TABLOCKS_IND1) where ICARD = @cMatric
	-- verificar diferenca de minutos
	select @difminuto = DATEDIFF(minute, @dh_lock, getdate())
	if (@difminuto > 2)
	begin
		-- modifica data e hora do lock
		update TABLOCKS set DATAHORA = getdate(), USUARIO = @cUsuario 
		    where ICARD = @cMatric
		select @ret = 0
	end
	else
	begin
		select @ret = -1     -- lock ativo
	end
   end
   return (@ret)
END
GO
