DROP PROCEDURE release_lock
GO
CREATE PROCEDURE release_lock @cMatric CHAR(12), @QuemPediu char(15)
AS

DECLARE @Ret int, @cUsu char(15)

BEGIN
   -- verifica se a matricula esta lockada
   IF NOT EXISTS (SELECT * from TABLOCKS WITH (Index = TABLOCKS_IND1) where ICARD = @cMatric)
   begin
	select @Ret = -1       -- nao encontrou matricula que se quer unlockar
   end
   -- se matricula lockada, retira lock se foi o proprio usuario que lockou
   else
   begin
	select @cUsu = USUARIO from TABLOCKS WITH (Index = TABLOCKS_IND1) where ICARD = @cMatric
	if (@cUsu = @QuemPediu)
	begin
		delete from TABLOCKS where ICARD = @cMatric
		select @Ret = 0
	end
	else
	begin
		select @Ret = -2
	end
   end
   return (@Ret)
END
GO
