use ACESSOTA
go
PRINT ''
PRINT 'Criando table CONTROLE...'
go

DROP TABLE CONTROLE
GO
CREATE TABLE CONTROLE (
  ICARD        CHAR(12) NOT NULL,
  GRUPO        CHAR(3)  default '000' 		NOT NULL, 
  CODIG        CHAR(6)  default '      ',
  TPFIS        CHAR(1)  default ' ',       
  SITUA        CHAR(1)  default '1' 		NOT NULL,
  SUBNV        CHAR(5)  default '00   ',    -- 99 niveis
  PLANTA       CHAR(3)  default '000',
  DATAHORA     CHAR(10) default '3112202359',
  ULTRS        CHAR(25) default '0101902359               ',
  FX_FLG       CHAR(1)  default '0',
  FX_DTA       CHAR(11) default '           ',
  TEMPO_ALM    CHAR(3)  default '   ',
  DATINI       CHAR(6)  default '      ',
  DATFIM       CHAR(6)  default '      ',
  MENSAGEM     CHAR(32) default ' ',
  DTA_MENS     CHAR(6)  default '      ',
  QTD_MENS     CHAR(2)  default '  ',
  CRED_FX1     CHAR(2)  default '00',
  FX_1         CHAR(8)  default '24002400',
  CRED_FX2     CHAR(2)  default '00',
  FX_2         CHAR(8)  default '24002400',
  CRED_FX3     CHAR(2)  default '00',
  FX_3         CHAR(8)  default '24002400',
  CRED_FX4     CHAR(2)  default '00',
  FX_4         CHAR(8)  default '24002400',
  CRED_FX5     CHAR(2)  default '00',
  FX_5         CHAR(8)  default '24002400',
  CRED_FX6     CHAR(2)  default '00',
  FX_6         CHAR(8)  default '24002400',
  ULTPAS_REF   CHAR(10) default '          ',
  TITULAR      CHAR(12) default '            ',
  GRUPO1       CHAR(3)  default '000',
  DATINIG1     CHAR(10) default '          ',
  DATFIMG1     CHAR(10) default '          ',
  GRUPO2       CHAR(3)  default '000',
  DATINIG2     CHAR(10) default '          ',
  DATFIMG2     CHAR(10) default '          ',
  GRUPO3       CHAR(3)  default '000',
  DATINIG3     CHAR(10) default '          ',
  DATFIMG3     CHAR(10) default '          ',
  GRUPO_SAB    CHAR(3)  default '000',
  GRUPO_DOM    CHAR(3)  default '000',
  GRUPO_FER    CHAR(3)  default '000',
  ANTI_DUPLA   CHAR(1)  default '1' 		NOT NULL CONSTRAINT anti_d CHECK (ANTI_DUPLA IN ('0','1')),
  BLOQ_FALTA   CHAR(1)  default '0'		NOT NULL CONSTRAINT bloq_f CHECK (BLOQ_FALTA IN ('0','1')),
  VER_HORA     CHAR(1)  default '1'		NOT NULL CONSTRAINT v_hora CHECK (VER_HORA IN ('0','1', '2', '3')),
  VER_LOCAL    CHAR(1)  default '1'		NOT NULL CONSTRAINT v_local CHECK (VER_LOCAL IN ('0','1')),
  VER_VALID    CHAR(1)  default '1'		NOT NULL CONSTRAINT v_valid CHECK (VER_VALID IN ('0','1')),
  VER_AFAST    CHAR(1)  default '1'		NOT NULL CONSTRAINT v_afast CHECK (VER_AFAST IN ('0','1')),
  VER_CRED     CHAR(1)  default '1'		NOT NULL CONSTRAINT v_cred CHECK (VER_CRED IN ('0','1', '2', '3')),
  VIS_ESP      CHAR(1)  default '0',
  FLG_TEMPO_MIN	   CHAR(1)  default '0',
  ULT_MARC_PONTO   CHAR(10) default '          ',
  TEMPO_MINIMO	   CHAR(3)  default '000',
  TOL_ENTRADA	   CHAR(2)  default '00',
  TOL_SAIDA	   CHAR(2)  default '00',
  NUMSERIAL    CHAR(10) default '0000000000' NOT NULL,
  VER_DIGIT    CHAR(1)	default '2'		NOT NULL CONSTRAINT v_digit CHECK (VER_DIGIT IN ('1', '2')),
  TEMPO_RET    CHAR(3)  default '000'	NOT NULL CONSTRAINT tempo_ret CHECK (convert(int,TEMPO_RET) >= 0),
  TOLER_RET    CHAR(3)  default '000'	NOT NULL CONSTRAINT toler_ret CHECK (convert(int,TOLER_RET) >=0),
  VER_RET      CHAR(1)  default '0'		NOT NULL CONSTRAINT v_ret CHECK (VER_RET IN ('0','1')),
  TEMPO_JORNADA CHAR(3) default '540' 	NOT NULL CONSTRAINT tpo_jornada CHECK (convert(int,TEMPO_JORNADA) >= 0),
  VER_SAIDAMAX CHAR(1)  default '0'		NOT NULL CONSTRAINT v_saidamax CHECK (VER_SAIDAMAX IN ('0','1'))
)

-- *******************************************************
PRINT ''
PRINT 'Criando table FXHORARIA...'
go

DROP TABLE FXHORARIA
GO
CREATE TABLE FXHORARIA (
ICARD CHAR(12) NOT NULL,
FX_DOM_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SEG_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_TER_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_QUA_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_QUI_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SEX_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SAB_A CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_DOM_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SEG_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_TER_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_QUA_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_QUI_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SEX_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_SAB_P CHAR(56) DEFAULT '24002400240024002400240024002400240024002400240024002400' NOT NULL,
FX_REF   CHAR(56) default '24002400240024002400240024002400240024002400240024002400' NOT NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table FERIADO...'
go

DROP TABLE FERIADO
GO
CREATE TABLE FERIADO (
DATA_FER 	DATETIME 	NOT NULL,
DESC_FER	CHAR(30) null,
PLANTA_FER	CHAR(3) default '000'
)

-- *******************************************************
PRINT ''
PRINT 'Criando table CP_BN...'
go

DROP TABLE CP_BN
GO

CREATE TABLE CP_BN (
  END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
  BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
  AVISO	       CHAR(2)	 NOT NULL,
  ST           CHAR(1)   NOT NULL,
  TERM         CHAR(2)   DEFAULT '00' NOT NULL,
  EPN3         CHAR(30)  DEFAULT ' '
)

-- *******************************************************
PRINT ''
PRINT 'Criando table CP_NB...'
go

DROP TABLE CP_NB
GO
CREATE TABLE CP_NB (
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip2 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  BLUEB	       CHAR(2)  DEFAULT '00' NOT NULL CONSTRAINT tp_blueb2 CHECK (convert(int,BLUEB) >= 0),
  CODIN        CHAR(2)  DEFAULT '00' NOT NULL CONSTRAINT tp_codin2 CHECK ((convert(int,CODIN) >= 0) and (convert(int,CODIN) <= 11)),   
  ST	       CHAR(1)	NOT NULL,
  CC 	       CHAR(2)	NOT NULL,
  TIPO_CC      CHAR(1)	NOT NULL CONSTRAINT tp_cc CHECK (TIPO_CC IN ('0','1')),
  ACAO	       CHAR(15) DEFAULT ' '
)

-- *******************************************************
PRINT ''
PRINT 'Criando table DAM00...'
go

DROP TABLE DAM00
GO
CREATE TABLE DAM00 (
  ICARD          CHAR(12)	NOT NULL,
  DIAM           CHAR(2)	NOT NULL,
  MESM           CHAR(2)	NOT NULL,
  ANOM           CHAR(2)	NOT NULL,
  HORAM          CHAR(4)	NOT NULL,
  SEGUNDO        CHAR(2)	NOT NULL,
  CODAC          CHAR(2)	NOT NULL,
  POSIC          CHAR(1)	NOT NULL,
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT          CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	 CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
  CODFNC         CHAR(2)	DEFAULT '  ' NULL,
  ONOFF		 CHAR(1)	NOT NULL,
  VEICULO	 VARCHAR(15)    NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table DAM01...'
go

DROP TABLE DAM01
GO
CREATE TABLE DAM01 (
  ICARD          CHAR(12)	NOT NULL,
  DIAM           CHAR(2)	NOT NULL,
  MESM           CHAR(2)	NOT NULL,
  ANOM           CHAR(2)	NOT NULL,
  HORAM          CHAR(4)	NOT NULL,
  SEGUNDO        CHAR(2)	NOT NULL,
  CODAC          CHAR(2)	NOT NULL,
  POSIC          CHAR(1)	NOT NULL,
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT          CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	 CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
  CODFNC         CHAR(2)	DEFAULT '  ' NULL,
  VEICULO	 VARCHAR(15)	NULL,
  NIVEL		 CHAR(2)	DEFAULT '  ' NULL,
  FX_REF	 CHAR(2)	DEFAULT '  ' NULL,
  CRED_FX	 CHAR(2)	DEFAULT '  ' NULL,
  SITUA		 CHAR(2)	DEFAULT '  ' NULL,
  QTD_MENS	 CHAR(2)	DEFAULT '  ' NULL

)

-- *******************************************************
PRINT ''
PRINT 'Criando table DAM02...'
go

DROP TABLE DAM02
GO
CREATE TABLE DAM02 (
  ICARD          CHAR(12)	NOT NULL,
  DIAM           CHAR(2)	NOT NULL,
  MESM           CHAR(2)	NOT NULL,
  ANOM           CHAR(2)	NOT NULL,
  HORAM          CHAR(4)	NOT NULL,
  SEGUNDO        CHAR(2)	NOT NULL,
  CODAC          CHAR(2)	NOT NULL,
  POSIC          CHAR(1)	NOT NULL,
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT          CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	 CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
  CODFNC         CHAR(2)	DEFAULT '  ' NULL,
  VEICULO	 VARCHAR(15)	NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table DAM03...'
go

DROP TABLE DAM03
GO
CREATE TABLE DAM03 (
  ICARD          CHAR(12)	NOT NULL,
  DIAM           CHAR(2)	NOT NULL,
  MESM           CHAR(2)	NOT NULL,
  ANOM           CHAR(2)	NOT NULL,
  HORAM          CHAR(4)	NOT NULL,
  SEGUNDO        CHAR(2)	NOT NULL,
  CODAC          CHAR(2)	NOT NULL,
  POSIC          CHAR(1)	NOT NULL,
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT          CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	 CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
  CODFNC         CHAR(2)	DEFAULT '  ' NULL,
  VEICULO	 VARCHAR(15)	NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table DAT07...'
go

DROP TABLE DAT07
GO
CREATE TABLE DAT07 (
  END_IP	 VARCHAR(15) 	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip1 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_blueb1 CHECK (convert(int,BLUEB) >= 0),
  CODIN          CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_codin1 CHECK ((convert(int,CODIN) >= 0) and (convert(int,CODIN) <= 11)),
  DESC_END	 	 CHAR(30)	DEFAULT ' ' NULL,
  LACES          CHAR(3) 	NOT NULL CONSTRAINT tp_laces1 CHECK (convert(int,LACES) >= 0),       
  TIP_TERM       CHAR(1)	NOT NULL CONSTRAINT tp_term CHECK (TIP_TERM IN ('1','2','3','4', '5')),
  FUSO           CHAR(4)    DEFAULT '0000' NOT NULL,
  PLANTA         CHAR(3)	DEFAULT '000' NOT NULL,
  BIO_TIPO       CHAR(1)    DEFAULT '0' NOT NULL CONSTRAINT bio_tipo1 CHECK (BIO_TIPO IN ('0','1','2','3','4','5', '6', '7','8')),
  TIP_LEIT 		 CHAR(1) 	DEFAULT '0' NOT NULL ,
  ATUFORC  		 CHAR(1)    DEFAULT '0' ,
  DATFORC  		 DATETIME	NULL,
  RASTREADOR	 CHAR(1)	DEFAULT '0' NOT NULL,
  POS_INIHALM	 CHAR(1) 	DEFAULT '0' NOT NULL CONSTRAINT pos_ihalm CHECK (pos_inihalm IN ('0','1','2')),
  POS_FIMHALM	 CHAR(1) 	DEFAULT '0' NOT NULL CONSTRAINT pos_falm CHECK (pos_fimhalm IN ('0','1','2')),
  VALID_RET	 	 CHAR(1) 	DEFAULT '0' NOT NULL CONSTRAINT b_ret CHECK (valid_ret IN ('0','1')),
  VALID_SAIDAMAX CHAR(1) 	DEFAULT '0' NOT NULL CONSTRAINT s_max CHECK (valid_saidamax IN ('0','1'))
)

-- *******************************************************
PRINT ''
PRINT 'Criando table DAT08...'
go

DROP TABLE DAT08
GO
CREATE TABLE DAT08 (
  GRUPO          CHAR(3) NOT NULL,
  LACES          CHAR(3) NOT NULL CONSTRAINT tp_laces2 CHECK (convert(int,LACES) >= 0),
  FXPERM         CHAR(56) DEFAULT '00002400000024000000240000002400000024000000240000002400' NOT NULL,
  PLANTA	 CHAR(3) DEFAULT '000' NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table DAT09...'
go

DROP TABLE DAT09
GO
CREATE TABLE DAT09 (
  ICARD          CHAR (12) NOT NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table SNBE...'
go

DROP TABLE SNBE
GO
CREATE TABLE SNBE (
  BLUEB          CHAR(2) NOT NULL CONSTRAINT tp_blueb3 CHECK (convert(int,BLUEB) >= 0),
  SINAL          CHAR(1) NOT NULL  CONSTRAINT tp_sinal1 CHECK (SINAL IN ('0','1','2','3','4','8','9')))

-- *******************************************************
PRINT ''
PRINT 'Criando table SBBE...'
go

DROP TABLE SBBE
GO
CREATE TABLE SBBE (
  SINAL         CHAR(1) NOT NULL CONSTRAINT tp_sinal2 CHECK (SINAL IN ('0','1')))

-- *******************************************************
-- PRINT ''
-- PRINT 'Criando table TABALARME...'
-- go

-- DROP TABLE TABALARME
-- CREATE TABLE TABALARME (
--   END_IP       CHAR(15)   NOT NULL,
--   ALARME       CHAR(2)   NOT NULL,
--   STATUS       CHAR(1)   NOT NULL,
--   INFORM       CHAR(15)
-- )



-- *******************************************************
PRINT ''
PRINT 'Criando table TABDEV...'
go

DROP TABLE TABDEV
GO
CREATE TABLE TABDEV(
  ICARD          CHAR(12)	NOT NULL,
  DIAM           CHAR(2)	NOT NULL,
  MESM           CHAR(2)	NOT NULL,
  ANOM           CHAR(2)	NOT NULL,
  HORAM          CHAR(4)	NOT NULL,
  SEGUNDO        CHAR(2)	NOT NULL,
  BLUEB          CHAR(2)	DEFAULT '00' NOT NULL,
  CODTT          CHAR(2)	DEFAULT '00' NOT NULL,
  END_IP	 CHAR(15)	DEFAULT '000.000.000.000'  NOT NULL,
  LISTA  	 VARCHAR(15)	NULL,
  STATUS         CHAR(1)	NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table TABLOCKS...'
go

DROP TABLE TABLOCKS
GO
CREATE TABLE TABLOCKS (
  ICARD		CHAR(12) NOT NULL,
  DATAHORA      CHAR(30) NOT NULL,
  USUARIO       CHAR(15) NOT NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table CONTDIG...'
go

DROP TABLE CONTDIG
GO
CREATE TABLE CONTDIG (
  ICARD 	CHAR(12) NOT NULL,
  TEMPL_TIT1	CHAR(160) NULL,
  TEMPL_TIT2	CHAR(160) NULL,
  TEMPL_TIT3	CHAR(160) NULL,
  TEMPL_TIT4	CHAR(160) NULL,
  TEMPL_ALT1	CHAR(160) NULL,
  TEMPL_ALT2	CHAR(160) NULL,
  TEMPL_ALT3	CHAR(160) NULL,
  TEMPL_ALT4	CHAR(160) NULL,
  NIVEL		CHAR(1) NULL,
  NUM_DEDO_PAD  CHAR(2) NULL,
  NUM_DEDO_ALT  CHAR(2) NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table MAPABIO...'
go

DROP TABLE MAPABIO
GO
CREATE TABLE MAPABIO (
  ICARD	       CHAR(12)  NOT NULL,
  END_IP       CHAR(15)  NOT NULL DEFAULT '000.000.000.000',
  TIPO_TEMPL   CHAR(1)   NOT NULL,
  NIVEL	       CHAR(1)   NOT NULL,
  BLUEB        CHAR(2)   NOT NULL DEFAULT '00',
  CODIN        CHAR(2)   NOT NULL DEFAULT '00'
)

-- *******************************************************
PRINT ''
PRINT 'Criando table SITENTRADA...'
go

DROP TABLE SITENTRADA
GO
CREATE TABLE SITENTRADA  (
  END_IP       CHAR(15)  DEFAULT '000.000.000.000'  NOT NULL,
  BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
  CODTT        CHAR(2)   DEFAULT '00' NOT NULL,
  DATA_ALARME  DATETIME		NOT NULL,
  ENTRADAS     CHAR(30)		NOT NULL,
  LOCAL_OCORR  CHAR(30)		NOT NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table CONTFUNC...'
go

DROP TABLE CONTFUNC
GO
CREATE TABLE CONTFUNC  (
  ICARD       CHAR(12)   NOT NULL,
  CODFUNC     CHAR(2)   DEFAULT '00' NOT NULL)

-- ********************** LISTAS DE BENEFICIOS *******************

PRINT ''
PRINT 'Criando table TERMBENEF...'
go

DROP TABLE TERMBENEF
GO
CREATE TABLE TERMBENEF (
  END_IP	VARCHAR(15)	DEFAULT '000.000.000.000'  NOT NULL CONSTRAINT tp_endip3 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  BLUEB		CHAR(2)	DEFAULT '00'  NOT NULL CONSTRAINT tp_blueb4 CHECK (convert(int,BLUEB) >= 0),
  TERM		CHAR(2)		DEFAULT '00'  NOT NULL CONSTRAINT tp_codin3 CHECK ((convert(int,TERM) >= 0) and (convert(int,TERM) <= 11)),  
  LBENEF 	CHAR(15)	NOT NULL CONSTRAINT nome_benef CHECK (LBENEF BETWEEN 'LBENEF00' AND 'LBENEF09' OR LBENEF BETWEEN 'LBENEF10' AND 'LBENEF19' OR LBENEF BETWEEN 'LBENEF20' AND 'LBENEF23'),
  IND_LIS 	CHAR(2)		NOT NULL CONSTRAINT nome_indlis CHECK ((CONVERT(char(2), IND_LIS) >= 0) AND (CONVERT(char(2), IND_LIS) <= 23))
)

-- *******************************************************
PRINT ''
PRINT 'Criando table BENEFICIO...'
go

DROP TABLE BENEFICIO
GO
CREATE TABLE BENEFICIO(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF00...'
go

DROP TABLE LBENEF00
GO
CREATE TABLE LBENEF00(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF01...'
go

DROP TABLE LBENEF01
GO
CREATE TABLE LBENEF01(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF02...'
go

DROP TABLE LBENEF02
GO
CREATE TABLE LBENEF02(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF03...'
go

DROP TABLE LBENEF03
GO
CREATE TABLE LBENEF03(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF04...'
go

DROP TABLE LBENEF04
GO
CREATE TABLE LBENEF04(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF05...'
go

DROP TABLE LBENEF05
GO
CREATE TABLE LBENEF05(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF06...'
go

DROP TABLE LBENEF06
GO
CREATE TABLE LBENEF06(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF07...'
go

DROP TABLE LBENEF07
GO
CREATE TABLE LBENEF07(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF08...'
go

DROP TABLE LBENEF08
GO
CREATE TABLE LBENEF08(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF09...'
go

DROP TABLE LBENEF09
GO
CREATE TABLE LBENEF09(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF10...'
go

DROP TABLE LBENEF10
GO
CREATE TABLE LBENEF10(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF11...'
go

DROP TABLE LBENEF11
GO
CREATE TABLE LBENEF11(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF12...'
go

DROP TABLE LBENEF12
GO
CREATE TABLE LBENEF12(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF13...'
go

DROP TABLE LBENEF13
GO
CREATE TABLE LBENEF13(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF14...'
go

DROP TABLE LBENEF14
GO
CREATE TABLE LBENEF14(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF15...'
go

DROP TABLE LBENEF15
GO
CREATE TABLE LBENEF15(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF16...'
go

DROP TABLE LBENEF16
GO
CREATE TABLE LBENEF16(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF17...'
go

DROP TABLE LBENEF17
GO
CREATE TABLE LBENEF17(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF18...'
go

DROP TABLE LBENEF18
GO
CREATE TABLE LBENEF18(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF19...'
go

DROP TABLE LBENEF19
GO
CREATE TABLE LBENEF19(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF20...'
go

DROP TABLE LBENEF20
GO
CREATE TABLE LBENEF20(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF21...'
go

DROP TABLE LBENEF21
GO
CREATE TABLE LBENEF21(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF22...'
go

DROP TABLE LBENEF22
GO
CREATE TABLE LBENEF22(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table LBENEF23...'
go

DROP TABLE LBENEF23
GO
CREATE TABLE LBENEF23(
  ICARD       CHAR(12)			NOT NULL,
  CREDITOS    CHAR(2) DEFAULT '00'	NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table INFOMAT...'
go

DROP TABLE INFOMAT
GO
CREATE TABLE INFOMAT (
  CAMPO_BLOQ	CHAR(5) NOT NULL CONSTRAINT ck_cpo_bloq CHECK (CAMPO_BLOQ IN ('SAD','TIPO')),
  POS_INIC	CHAR(2) NOT NULL CONSTRAINT ck_pos_bloq CHECK (convert(int,POS_INIC) BETWEEN 1 AND 12),
  TAMANHO	CHAR(1) NOT NULL CONSTRAINT ck_tam_bloq CHECK (convert(int,TAMANHO) BETWEEN 1 AND 9)
)

-- *******************************************************
PRINT ''
PRINT 'Criando table BLOQSAD...'
go

DROP TABLE BLOQSAD
GO
CREATE TABLE BLOQSAD (
  SAD		CHAR(9)	NOT NULL,
  BLOQUEADO	CHAR(1) DEFAULT '0' NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table BLOQTIPO...'
go

DROP TABLE BLOQTIPO
GO
CREATE TABLE BLOQTIPO (
  TIPO		CHAR(9)	NOT NULL,
  BLOQUEADO	CHAR(1)	DEFAULT '0' NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table EXCESAD...'
go

DROP TABLE EXCESAD
GO
CREATE TABLE EXCESAD (
  ICARD        CHAR(12) NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table EXCETIPO...'
go

DROP TABLE EXCETIPO
GO
CREATE TABLE EXCETIPO (
  ICARD        CHAR(12) NOT NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table CONTDIG_VERI...'
go

DROP TABLE CONTDIG_VERI
GO
CREATE TABLE CONTDIG_VERI (
  ICARD 	CHAR(12) NOT NULL,
  TEMPL_TIT1	CHAR(160) NULL,
  TEMPL_TIT2	CHAR(160) NULL,
  TEMPL_TIT3	CHAR(160) NULL,
  TEMPL_TIT4	CHAR(160) NULL,
  TEMPL_TIT5	CHAR(56) NULL,
  TEMPL_ALT1	CHAR(160) NULL,
  TEMPL_ALT2	CHAR(160) NULL,
  TEMPL_ALT3	CHAR(160) NULL,
  TEMPL_ALT4	CHAR(160) NULL,
  TEMPL_ALT5    CHAR(56) NULL,
  NIVEL		CHAR(1) NULL,
  NUM_DEDO_PAD  CHAR(2) NULL,
  NUM_DEDO_ALT  CHAR(2) NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table CONTDIG_OMOK...'
go

DROP TABLE CONTDIG_OMOK
GO
CREATE TABLE CONTDIG_OMOK (
  ICARD 	CHAR(12) NOT NULL,
  TEMPL_TIT1	CHAR(160) NULL,
  TEMPL_TIT2	CHAR(160) NULL,
  TEMPL_TIT3	CHAR(160) NULL,
  TEMPL_TIT4	CHAR(160) NULL,
  TEMPL_TIT5	CHAR(160) NULL,
  TEMPL_TIT6    CHAR(26) NULL,
  TEMPL_ALT1	CHAR(160) NULL,
  TEMPL_ALT2	CHAR(160) NULL,
  TEMPL_ALT3	CHAR(160) NULL,
  TEMPL_ALT4	CHAR(160) NULL,
  TEMPL_ALT5    CHAR(160) NULL,
  TEMPL_ALT6    CHAR(26) NULL,
  TEMPL_COA1	CHAR(160) NULL,
  TEMPL_COA2	CHAR(160) NULL,
  TEMPL_COA3	CHAR(160) NULL,
  TEMPL_COA4	CHAR(160) NULL,
  TEMPL_COA5    CHAR(160) NULL,
  TEMPL_COA6    CHAR(26) NULL,
  NIVEL		CHAR(1) NULL,
  NUM_DEDO_PAD  CHAR(2) NULL,
  NUM_DEDO_ALT  CHAR(2) NULL,
  NUM_DEDO_COA  CHAR(2) NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table CONTDIG_SAGEM...'
go
DROP TABLE CONTDIG_SAGEM;
GO

CREATE TABLE CONTDIG_SAGEM (
  ICARD 		CHAR(12) NOT NULL,
  TEMPL_TIT1	CHAR(160) NULL,
  TEMPL_TIT2	CHAR(160) NULL,
  TEMPL_TIT3	CHAR(160) NULL,
  TEMPL_TIT4	CHAR(32) NULL,
  TEMPL_ALT1	CHAR(160) NULL,
  TEMPL_ALT2	CHAR(160) NULL,
  TEMPL_ALT3	CHAR(160) NULL,
  TEMPL_ALT4	CHAR(32) NULL,
  TEMPL_COA1	CHAR(160) NULL,
  TEMPL_COA2	CHAR(160) NULL,
  TEMPL_COA3	CHAR(160) NULL,
  TEMPL_COA4	CHAR(32) NULL,
  NIVEL		CHAR(1) default '0' NULL,
  NUM_DEDO_PAD  CHAR(2) default '00' NULL,
  NUM_DEDO_ALT  CHAR(2) default '00' NULL,
  NUM_DEDO_COA  CHAR(2) default '00' NULL,
  STATUS 	CHAR(1)	DEFAULT '0' NULL
)


-- *******************************************************
PRINT ''
PRINT 'Criando table CONTDIG_TSI1...'
go

DROP TABLE CONTDIG_TSI1
GO
CREATE TABLE CONTDIG_TSI1 (
  ICARD 	CHAR(12) NOT NULL,
  TEMPL_TIT1	CHAR(160) NULL,
  TEMPL_TIT2	CHAR(160) NULL,
  TEMPL_TIT3	CHAR(160) NULL,
  TEMPL_TIT4	CHAR(160) NULL,
  TEMPL_TIT5	CHAR(128) NULL,
  TEMPL_ALT1	CHAR(160) NULL,
  TEMPL_ALT2	CHAR(160) NULL,
  TEMPL_ALT3	CHAR(160) NULL,
  TEMPL_ALT4	CHAR(160) NULL,
  TEMPL_ALT5    CHAR(128) NULL,
  TEMPL_COA1	CHAR(160) NULL,
  TEMPL_COA2	CHAR(160) NULL,
  TEMPL_COA3	CHAR(160) NULL,
  TEMPL_COA4	CHAR(160) NULL,
  TEMPL_COA5    CHAR(128) NULL,
  NIVEL		CHAR(1) NULL,
  NUM_DEDO_PAD  CHAR(2) NULL,
  NUM_DEDO_ALT  CHAR(2) NULL,
  NUM_DEDO_COA  CHAR(2) NULL,
  STATUS 	CHAR(1)	DEFAULT '0' NULL
)

-- *******************************************************
PRINT ''
PRINT 'Criando table CONTVEI...'
go

DROP TABLE CONTVEI
GO
CREATE TABLE CONTVEI (
  ICARD         CHAR(12) NOT NULL,
  ICARDV	CHAR(12) NOT NULL,
  DATAHORA	CHAR(10) DEFAULT '3112202359',
  SITUA 	CHAR(1)  DEFAULT '0')

-- 14/11/2003 HENDRIKA

-- *******************************************************
PRINT ''
PRINT 'Criando table ATUALI...'
go

DROP TABLE ATUALI
GO
CREATE TABLE ATUALI (
  IDENTIF	CHAR(14)	NOT NULL,
  NUMSERIAL	CHAR(10)	NOT NULL,
  ICARD		CHAR(12)	DEFAULT '000000000000' NULL,
  NUMCPO	CHAR(2)		NOT NULL,
  INFORM	VARCHAR(56)	NOT NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table LIMPATU...'
go

DROP TABLE LIMPATU
GO
CREATE TABLE LIMPATU (
  IDENTIF	CHAR(14)	NOT NULL,
  NUMSERIAL	CHAR(10)	NOT NULL,
  DATA_ATU	CHAR(10)	DEFAULT '0101010000' NULL,
  END_IP    CHAR(15)	DEFAULT '000.000.000.000' NOT NULL,
  BLUEB     CHAR(2)		DEFAULT '00' NOT NULL,
  CODTT     CHAR(2)		DEFAULT '00' NOT NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table PENDSMART...'
go

DROP TABLE PENDSMART
GO
CREATE TABLE PENDSMART (
  END_IP	CHAR(15) DEFAULT '000.000.000.000' NOT NULL,
  BLUEB		CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_blueb5 CHECK (convert(int,BLUEB) >= 0),
  CODIN 	CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_codin5 CHECK ((CONVERT(int,CODIN) >= 0) and (CONVERT(INT,CODIN) <= 11)),
  NUMSERIAL	CHAR(10) NOT NULL,
  IDENTIF	CHAR(14) NOT NULL,
  NUMCPO	CHAR(2)	DEFAULT '  ' NULL,
  INFORM	VARCHAR(56) DEFAULT '          ' NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table EXPIREATU...'
go

DROP TABLE EXPIREATU
GO
CREATE TABLE EXPIREATU (
  IDENTIF	CHAR(14) NOT NULL,
  NUMSERIAL	CHAR(10) NOT NULL,
  DATA_EXP	CHAR(10) DEFAULT '0101010000' NULL,
  END_IP	CHAR(15) DEFAULT '000.000.000.000' NOT NULL,
  BLUEB		CHAR(2)  DEFAULT '00' NOT NULL,
  CODTT     CHAR(2)  DEFAULT '00' NOT NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table CREDLOG...'
go

DROP TABLE CREDLOG
GO
CREATE TABLE CREDLOG (
  ICARD	CHAR(12) 	NOT NULL,
  ANO	CHAR(4) 	DEFAULT '0000' NOT NULL,
  MES	CHAR(2) 	DEFAULT '00' NOT NULL,
  DIA	CHAR(2) 	DEFAULT '00' NOT NULL,
  HORA	CHAR(4) 	DEFAULT '0000' NOT NULL,
  SEGUNDO CHAR(2) 	DEFAULT '00' NOT NULL,
  TIPO	CHAR(1) 	DEFAULT '0' NOT NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table VEICULO...'
go

DROP TABLE VEICULO
GO
CREATE TABLE VEICULO (
  ICARDV CHAR(12) NOT NULL,
  NUMSERIAL CHAR(10) default '0000000000' NOT NULL)

-- *******************************************************

PRINT ''
PRINT 'Criando table COUNT_BY_VEIC...'
go

DROP TABLE COUNT_BY_VEIC
GO
CREATE TABLE COUNT_BY_VEIC (
  ICARDV CHAR(12) NOT NULL PRIMARY KEY,
  CNT SMALLINT CONSTRAINT cnt_ate_60 CHECK ( CNT < 61 ) )
--ORGANIZATION INDEX AS 
--SELECT ICARDV, count(*) from CONTVEI GROUP BY ICARDV
GO

--@@TRIGVEIC;

-- *******************************************************
PRINT ''
PRINT 'Criando table SITCOLETOR...'
go

DROP TABLE SITCOLETOR
GO
CREATE TABLE SITCOLETOR (
  ENDIP 	CHAR(15) DEFAULT '000.000.000.000' NOT NULL,
  BLUEB 	CHAR(2)	 DEFAULT '00' NOT NULL,
  CODIN 	CHAR(2)  DEFAULT '00' NOT NULL,
  ID_CONEX 	CHAR(15) DEFAULT '000.000.000.000' NOT NULL,
  DISPOSITIVO 	CHAR(1)  DEFAULT '1' NOT NULL,
  STATUS	CHAR(1)	 DEFAULT '0' NOT NULL,
  LSTPEND	CHAR(5)	 DEFAULT '     ' NULL,
  LSTLOGS	CHAR(5)  DEFAULT '     ' NULL,
  DT_ATUALI	DATETIME NULL)  


-- *******************************************************
PRINT ''
PRINT 'Criando table MATCODIN...'
go

DROP TABLE MATCODIN
GO
CREATE TABLE MATCODIN (
  ICARD 	CHAR(12) NOT NULL,
  END_IP	CHAR(15) DEFAULT '000.000.000.000' NOT NULL,
  BLUEB		CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_blueb6 CHECK (convert(int,BLUEB) >= 0),
  CODIN 	CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_codin6 CHECK ((CONVERT(int,CODIN) >= 0) and (CONVERT(INT,CODIN) <= 11)),
  DIASEM	CHAR(1) DEFAULT '0' NOT NULL CONSTRAINT ck_diasem CHECK (convert(int,DIASEM) BETWEEN 0 AND 8),
  FXPERM        CHAR(56) DEFAULT '00002400000024000000240000002400000024000000240000002400' NOT NULL)


-- *******************************************************
PRINT ''
PRINT 'Criando table CONTPLANTA...'
go

DROP TABLE CONTPLANTA
GO
CREATE TABLE CONTPLANTA (
  ICARD 	CHAR(12) NOT NULL,
  PLANTACESSO   CHAR(3) DEFAULT '000' NOT NULL,
  DATAHORA      CHAR(10) default '3112202359' NOT NULL)


-- *******************************************************
PRINT ''
PRINT 'Criando table GEOMOK001...'
go

DROP TABLE GEOMOK001
GO
CREATE TABLE GEOMOK001 (
  END_IP	CHAR(15) DEFAULT '000.000.000.000' NOT NULL,
  BLUEB		CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_blueb7 CHECK (convert(int,BLUEB) >= 0),
  CODIN 	CHAR(2)	DEFAULT '00' NOT NULL CONSTRAINT tp_codin7 CHECK ((CONVERT(int,CODIN) >= 0) and (CONVERT(INT,CODIN) <= 11)),
  NIVEL		CHAR(1)	DEFAULT '2' NOT NULL CONSTRAINT niv_geomok CHECK ((CONVERT(int,nivel) BETWEEN 1 AND 7)),
  NIVELSAG 	CHAR(2) DEFAULT '05' CONSTRAINT niv_SAGEN CHECK (convert(int,NIVELSAG) BETWEEN 0 AND 10))

-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON001...'
go

DROP TABLE PEND_ON001;
GO
CREATE TABLE PEND_ON001 (
   IDENTIF 		CHAR(14) NOT NULL,
   NUMSERIAL	CHAR(10) NOT NULL,
   ICARD		CHAR(12) DEFAULT '000000000000' NULL,
   TIPO         CHAR(1)  default ' ' NULL,       
   NUMCPO		CHAR(2)	NOT NULL,
   INFORM		VARCHAR(56) NOT NULL,
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   DATA_EXP		DATETIME  NULL,
   STATUS   	CHAR(1)   DEFAULT '0',
   TIPO_ATU		CHAR(1)	  DEFAULT '1')

-- *******************************************************
--PRINT ''
--PRINT 'Criando table PEND_ON002...'
--go

--DROP TABLE PEND_ON002;
--GO
--CREATE TABLE PEND_ON002 (
--   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
--   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
--   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
--   QTD_LIVRE    SMALLINT  DEFAULT 0,
--   STATUS   	CHAR(1)   DEFAULT '0' NULL,
--   QHOR_EXP		TINYINT	  DEFAULT 12,
--   DATA_INI		DATETIME  NULL,
--   QTD_LIVREOFF SMALLINT   DEFAULT 0,
--   STATUS_OFF   CHAR(1)	  DEFAULT '0' NULL,
--   QHOR_EXPOFF  TINYINT   DEFAULT 0,
--   DATA_INIOFF  DATETIME  NULL,
--   STATUS_LPZ   CHAR(1)	  DEFAULT '0',
--   DATA_INILPZ	DATETIME NULL) 	


-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON003...'
go

DROP TABLE PEND_ON003;
GO
CREATE TABLE PEND_ON003 (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   NUMSERIAL	CHAR(10)	NOT NULL,
   IDENTIF	CHAR(14)	NOT NULL,
   QHOR_EXP	TINYINT	  DEFAULT 12) 	


-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON004...'
go

DROP TABLE PEND_ON004;
GO
CREATE TABLE PEND_ON004 (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   NUMSERIAL	CHAR(10)  NOT NULL,
   IDENTIF	CHAR(14)  NOT NULL,
   NUMCPO	CHAR(2)	  NOT NULL,
   INFORM	CHAR(10)	  NOT NULL) 	


-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON005...'
go

DROP TABLE PEND_ON005;
GO
CREATE TABLE PEND_ON005 (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   NUMSERIAL	CHAR(10)	NOT NULL,
   IDENTIF	CHAR(14)	NOT NULL,
   MODO_ATU	CHAR(1)		NOT NULL) 	


-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON006...'
go

DROP TABLE PEND_ON006;
GO
CREATE TABLE PEND_ON006 ( 
  IDENTIF	CHAR(14) NOT NULL, 
  NUMSERIAL	CHAR(10) NOT NULL, 
  END_IP	CHAR(15) DEFAULT '000.000.000.000' NOT NULL, 
  BLUEB		CHAR(2) DEFAULT '00' NOT NULL, 
  CODIN		CHAR(2) DEFAULT '00' NOT NULL, 
  STATUS	CHAR(1) DEFAULT '0' NULL, 
  MODO_ATU	CHAR(1) DEFAULT '1' NULL)  


-- *******************************************************
PRINT ''
PRINT 'Criando table LOGPEND...'
go

DROP TABLE LOGPEND;
GO
CREATE TABLE LOGPEND (
  IDENTIF 	char(14) not null,
  INCLUSAO 	DATETIME default getdate() not null,
  EVENTO 	char(2) not null,
  NUMSERIAL 	char(10) not null,
  ICARD  	char(12) not null,
  NUMCPO 	char(2) not null,
  INFORM 	varchar(56) not null,
  END_IP 	char(15) default '000.000.000.000' not null,
  BLUEB  	char(2) DEFAULT '00' NULL,
  CODIN  	char(2) DEFAULT '00' NULL,
  IDENTIF_REF   char(14) null,
  TIPO_ATU	char(1) default '1' NULL) 


-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_GRUPO...'
go
DROP TABLE PEND_GRUPO;
GO
CREATE TABLE PEND_GRUPO (
  ICARD		CHAR(12) NOT NULL,
  NUMSERIAL	CHAR(10) default '0000000000'	NOT NULL,
  GRUPO		CHAR(3)  default '000' NULL, 
  GRUPO_ANT	CHAR(3)  default '000' NULL, 
  GRUPO1	CHAR(3)  default '000' NULL,
  GRUPO1_ANT	CHAR(3)  default '000' NULL,
  GRUPO2	CHAR(3)  default '000' NULL,
  GRUPO2_ANT	CHAR(3)  default '000' NULL,
  GRUPO3	CHAR(3)  default '000' NULL,
  GRUPO3_ANT	CHAR(3)  default '000' NULL,
  GRUPO_SAB	CHAR(3)  default '000' NULL,
  GRUPO_SAB_ANT	CHAR(3)  default '000' NULL,
  GRUPO_DOM	CHAR(3)  default '000' NULL,
  GRUPO_DOM_ANT	CHAR(3)  default '000' NULL,
  GRUPO_FER	CHAR(3)  default '000' NULL,
  GRUPO_FER_ANT	CHAR(3)  default '000' NULL)


-- *******************************************************
PRINT ''
PRINT 'Criando temporary table TMP_LISTAPENDENCIA...'
go
DROP TABLE TMP_LISTAPENDENCIA;
GO
CREATE TABLE TMP_LISTAPENDENCIA (
	END_IP		char(15)  NOT NULL ,
	NUMSERIAL 	char(10)  NULL ,
	IDENTIF 	char(14)  NULL 
) 


-- *******************************************************
PRINT ''
PRINT 'Criando temporary table TMP_CODINS...'
go
DROP TABLE TMP_CODINS;
GO
CREATE TABLE TMP_CODINS (
	IDENTIF 	char(14) NULL ,
	NUMSERIAL 	char(10) NULL ,
	ICARD 		char(12) NULL ,
	NUMCPO 		char(2) NULL ,
	INFORM 		char(56) NULL ,
	END_IP 		char(15) NULL 
) 


-- *******************************************************
PRINT ''
PRINT 'Criando temporary table TMP_LISTALIMPAOFF...'
go
DROP TABLE TMP_LISTALIMPAOFF;
GO
CREATE TABLE TMP_LISTALIMPAOFF (
	END_IP 		char(15) NOT NULL ,
	NUMSERIAL 	char(10) NULL ,
	IDENTIF 	char(14) NULL ,
	MODO_ATU 	char(1) NULL,
	id_num 		int IDENTITY(1,1)
)


-- *******************************************************
PRINT ''
PRINT 'Criando temporary table TMP_LISTAPENDENCIA_OFF...'
go
DROP TABLE TMP_LISTAPENDENCIA_OFF;
GO
CREATE TABLE TMP_LISTAPENDENCIA_OFF (
	END_IP 		CHAR(15) NULL ,
	NUMSERIAL 	CHAR(10) NULL ,
	IDENTIF 	CHAR(14) NULL ,
	TIPO_ATU 	CHAR(1) NULL ,
	NUMCPO 		CHAR(2) NULL ,
	INFORM 		VARCHAR(10) NULL 
)

-- *******************************************************
PRINT ''
PRINT 'Criando table DATAHORA...'
go
DROP TABLE DATAHORA;
GO

CREATE TABLE DATAHORA (
  ICARD        CHAR(12) NOT NULL,
  INI_HALM     DATETIME default CAST('01-01-06 00:00:00' AS datetime) NOT NULL,
  FIM_HALM     DATETIME default CAST('01-01-06 00:00:00' AS datetime) NOT NULL,
  INI_INTJ     DATETIME default CAST('01-01-06 00:00:00' AS datetime) NOT NULL,
  FIM_INTJ     DATETIME default CAST('01-01-06 00:00:00' AS datetime) NOT NULL,
  FIM_ANTID	   DATETIME default CAST('01-01-06 00:00:00' AS datetime) NOT NULL
)


-- *******************************************************

PRINT ''
PRINT 'Criando table PEND_ON002ON...'
go

DROP TABLE PEND_ON002ON;
GO
CREATE TABLE PEND_ON002ON (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   QTD_LIVRE    SMALLINT  DEFAULT 0,
   STATUS   	CHAR(1)   DEFAULT '0' NULL,
   QHOR_EXP		TINYINT	  DEFAULT 12,
   QHOR_EXPOFF  TINYINT   DEFAULT 0,
   DATA_INI		DATETIME  NULL)
  
-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON002OFF...'
go

DROP TABLE PEND_ON002OFF;
GO
CREATE TABLE PEND_ON002OFF (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   QHOR_EXP		TINYINT	  DEFAULT 12,
   QTD_LIVREOFF SMALLINT   DEFAULT 0,
   STATUS_OFF   CHAR(1)	  DEFAULT '0' NULL,
   QHOR_EXPOFF  TINYINT   DEFAULT 0,
   DATA_INIOFF  DATETIME  NULL)

-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON002LPZ...'
go

DROP TABLE PEND_ON002LPZ;
GO
CREATE TABLE PEND_ON002LPZ (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   QHOR_EXP		TINYINT	  DEFAULT 12,
   QHOR_EXPOFF  TINYINT   DEFAULT 0,
   STATUS_LPZ   CHAR(1)	  DEFAULT '0',
   DATA_INILPZ	DATETIME NULL,
   HORA			CHAR(5)	  DEFAULT '99:99') 	



-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON007...'
go

DROP TABLE PEND_ON007;
GO
CREATE TABLE PEND_ON007 (
  IDENTIF 	char(14) not null,
  INCLUSAO 	DATETIME default getdate() not null,
  EVENTO 	char(2) not null,
  NUMSERIAL 	char(10) not null,
  ICARD  	char(12) not null,
  NUMCPO 	char(2) not null,
  INFORM 	varchar(56) not null,
  END_IP 	char(15) default '000.000.000.000' not null,
  BLUEB  	char(2) DEFAULT '00' NULL,
  CODIN  	char(2) DEFAULT '00' NULL,
  IDENTIF_REF   char(14) null,
  TIPO_ATU	char(1) default '1' NULL) 


-- *******************************************************

PRINT ''
PRINT 'Criando table PEND_ON008ON...'
go

DROP TABLE PEND_ON008ON;
GO
CREATE TABLE PEND_ON008ON (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   STATUS   	CHAR(1)   DEFAULT '0' NULL,
   QHOR_EXP		TINYINT	  DEFAULT 12)
  
-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON008OFF...'
go

DROP TABLE PEND_ON008OFF;
GO
CREATE TABLE PEND_ON008OFF (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   STATUS_OFF   CHAR(1)	  DEFAULT '0' NULL,
   QHOR_EXPOFF  TINYINT   DEFAULT 0)

-- *******************************************************
PRINT ''
PRINT 'Criando table PEND_ON008LPZ...'
go

DROP TABLE PEND_ON008LPZ;
GO
CREATE TABLE PEND_ON008LPZ (
   END_IP       CHAR(15)  DEFAULT '000.000.000.000' NOT NULL,
   BLUEB        CHAR(2)   DEFAULT '00' NOT NULL,
   CODIN        CHAR(2)   DEFAULT '00' NOT NULL,
   STATUS_LPZ   CHAR(1)	  DEFAULT '0') 	

-- *******************************************************
PRINT ''
PRINT 'Criando table TMP_DIG001...'
go

DROP TABLE TMP_DIG001
GO
CREATE TABLE TMP_DIG001 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip6 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO

-- *******************************************************
PRINT ''
PRINT 'Criando table TMP_DIG003...'
go

DROP TABLE TMP_DIG003
GO
CREATE TABLE TMP_DIG003 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip7 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO


-- *******************************************************
PRINT ''
PRINT 'Criando table DIG001...'
go

DROP TABLE DIG001
GO
CREATE TABLE DIG001 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip4 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO

-- *******************************************************
PRINT ''
PRINT 'Criando table DIG002...'
go

DROP TABLE DIG002
GO
CREATE TABLE DIG002 (
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip5 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  DATA_LOAD    DATETIME	DEFAULT GETDATE(),
  STATUS	CHAR(1),
  BIO_TIPO 	CHAR(1)
)
GO


-- *******************************************************
PRINT ''
PRINT 'Criando table DIG003...'
go

DROP TABLE DIG003
GO
CREATE TABLE DIG003 (
  ICARD        CHAR(12) NOT NULL,
  END_IP       VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip8 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  STATUS	CHAR(1),
  BIO_TIPO	CHAR(1)
)
GO

-- *******************************************************
PRINT ''
PRINT 'Criando table PWDTELE...'
go

DROP TABLE PWDTELE
GO
CREATE TABLE PWDTELE (
  SEN_USR    VARCHAR(30)   NOT NULL,
  SEN_PWD    VARCHAR(60)   NOT NULL
)
GO


-- *******************************************************
PRINT ''
PRINT 'Criando table DAT05...'
go

DROP TABLE DAT05
GO
CREATE TABLE DAT05 (
  NUMSERIAL	CHAR(10)	NOT NULL
)
GO


-- *******************************************************
-- tabela SISINFO 
PRINT ''
PRINT 'Criando table SISINFO...'
go

DROP TABLE SISINFO;
GO
CREATE TABLE SISINFO (
  NSISTEMA	SMALLINT  NOT  NULL CONSTRAINT tp_nsistema1 CHECK (NSISTEMA > 0),
  NVERSAO	VARCHAR(100),
  BASE		VARCHAR(30),
  DATINS 	DATETIME default getdate() not null,
  SEQ 		INT IDENTITY(1,1),
  LOCAL		VARCHAR(30),
  INFO		VARCHAR(250)
)
GO


-- *******************************************************
-- tabela DSPMENS, que informa qual equipamento / aplicativo tera armazenamento de log de mensagens
PRINT ''
PRINT 'Criando table DSPMENS...'
go

DROP TABLE DSPMENS;
GO
CREATE TABLE DSPMENS (
  END_IP    VARCHAR(15)	DEFAULT '000.000.000.000' NOT NULL CONSTRAINT tp_endip9 CHECK ((datalength(END_IP) = 15) and (END_IP NOT IN ('               '))),
  NSIST	   	CHAR(1) NOT  NULL  CONSTRAINT tp_nsistema2  CHECK (NSIST IN ('1','2')),		-- 1= CONEX, 2= CONEXREP
  ST	    CHAR(1) DEFAULT '0'	NOT NULL
) 
go


-- *******************************************************
-- tabela CONTCPF
PRINT ''
PRINT 'Criando table CONTCPF...'
go

DROP TABLE CONTCPF;
GO

CREATE TABLE CONTCPF (
  ICARD 	CHAR(12) NOT NULL,
  CPF		CHAR(11)  NOT NULL
)
GO


-- ************************  fim  *****************************
