DROP PROCEDURE sqlins_credlog
GO
CREATE PROCEDURE sqlins_credlog @cMatric VARCHAR(12), @cData VARCHAR(25), @nTipo INT AS 
DECLARE
    @nCont INT,
    @nMaximo INT,
    @cMatAux VARCHAR(12),
    @cAnoAux VARCHAR(4),
    @cMesAux VARCHAR(2),
    @cDiaAux VARCHAR(2),
    @cHoraAux VARCHAR(4),
    @cSegAux VARCHAR(2),
    @cTipoAux VARCHAR(1),
    @cAnoReg VARCHAR(4),
    @cMesReg VARCHAR(2),
    @cDiaReg VARCHAR(2),
    @cHoraReg VARCHAR(4),
    @cSegReg VARCHAR(2)
BEGIN
  SELECT @cAnoReg = substring(@cData, 1, 4)
  SELECT @cMesReg = substring(@cData, 5, 2) 
  SELECT @cDiaReg = substring(@cData, 7, 2)
  SELECT @cHoraReg = substring(@cData, 9, 4)
  SELECT @cSegReg = substring(@cData, 13, 2)
  -- verifica se ja existe a marcacao
  BEGIN
--    IF EXISTS (SELECT @cMatAux = ICARD FROM CREDLOG
    IF EXISTS (SELECT ICARD FROM CREDLOG
      WHERE ANO + MES + DIA + HORA + SEGUNDO = @cData AND
      ICARD = @cMatric AND
      TIPO = CONVERT(VARCHAR(2), @nTipo))
    BEGIN
      RETURN (1)
    END
    ELSE
    BEGIN
      -- verifica quantas marcacoes existem para o tipo de credito
      SELECT @nCont = COUNT(*)  FROM CREDLOG
        WHERE ICARD = @cMatric AND TIPO = @nTipo
      IF (@nTipo = 0) 		-- 0 = marcacao de refeitorio
	SELECT @nMaximo = 20
      ELSE			-- 1 = marcacao de beneficio
	SELECT @nMaximo = 5
      -- verifica se qtde de marcacoes atingiu o max de registros em tabela
      IF (@nCont >= @nMaximo)
      BEGIN
	DECLARE @CURSOR_ULTCRED CURSOR
	    SET @CURSOR_ULTCRED = CURSOR LOCAL SCROLL FOR
		SELECT ICARD, ANO, MES, DIA, HORA, SEGUNDO, TIPO 
	            FROM  CREDLOG
	            WHERE ICARD = @cMatric and
             	 	    TIPO = CONVERT(VARCHAR(2), @nTipo)
	            ORDER BY (ANO + MES + DIA + HORA + SEGUNDO)

        OPEN @CURSOR_ULTCRED
        FETCH @CURSOR_ULTCRED INTO @cMatAux, @cAnoAux, @cMesAux, @cDiaAux,
				  @cHoraAux, @cSegAux, @cTipoAux
        WHILE @@fetch_status = 0
        BEGIN
          FETCH NEXT FROM @CURSOR_ULTCRED INTO @cMatAux, @cAnoAux, @cMesAux, @cDiaAux, @cHoraAux, @cSegAux, @cTipoAux
        END
        CLOSE @CURSOR_ULTCRED
        DEALLOCATE @CURSOR_ULTCRED
        -- atualiza a marcacao mais antiga com esta ultima marcacao
        UPDATE CREDLOG SET ANO = @cAnoReg, MES = @cMesReg, DIA = @cDiaReg,
                           HORA = @cHoraReg, SEGUNDO = @cSegReg
          WHERE ANO = @cAnoAux AND
                MES = @cMesAux AND 
                DIA = @cDiaAux AND
                HORA = @cHoraAux AND
                SEGUNDO = @cSegAux AND
                ICARD = @cMatric AND
                TIPO = CONVERT(VARCHAR(2), @nTipo)
      END -- IF (@nCount
      ELSE
      BEGIN
        -- nao atingiu o maximo, insere este novo registro
        INSERT INTO CREDLOG (ICARD, TIPO, ANO, MES, DIA, HORA, SEGUNDO)
          VALUES (@cMatric, CONVERT(VARCHAR(2), @nTipo), @cAnoReg, @cMesReg,                   @cDiaReg, @cHoraReg, @cSegReg)    
      END
      COMMIT
      RETURN (0)		-- retorna marcacao nao existente	   
--      EXCEPTION
--      WHEN NO_DATA_FOUND THEN
--        INSERT INTO CREDLOG (ICARD, TIPO, ANO, MES, DIA, HORA, SEGUNDO)
--          VALUES (@cMatric, CONVERT(VARCHAR(2), @nTipo), @cAnoReg, @cMesReg,                   @cDiaReg, @cHoraReg, @cSegReg)		--	     
--        COMMIT
--        RETURN (0)
--      WHEN OTHERS THEN
--        RETURN (-1)
--      END    	    
    END -- ELSE BEGIN
  END
END
GO
