DROP PROCEDURE sqlcon_coacao_tsi1
GO
CREATE PROCEDURE sqlcon_coacao_tsi1 @cMatric char(12),
@cTempl_Coa1tot CHAR(160) OUTPUT, @cTempl_Coa2tot CHAR(160) OUTPUT, 
@cTempl_Coa3tot CHAR(160) OUTPUT, @cTempl_Coa4tot CHAR(160) OUTPUT, 
@cTempl_Coa5tot CHAR(160) OUTPUT, @cTempl_Coa6tot CHAR(160) OUTPUT 

AS
DECLARE @Retfun int, @Coa int, @cTempl_coa5aux AS CHAR(128)
BEGIN
	set @Retfun = 1
	set @Coa = 1
	select @cTempl_Coa1tot = NULL
	select @cTempl_Coa2tot = NULL
	select @cTempl_Coa3tot = NULL
	select @cTempl_Coa4tot = NULL
	select @cTempl_Coa5tot = NULL
	select @cTempl_Coa5aux = NULL
	select @cTempl_Coa6tot = NULL
	
	-- procura por Templates da matricula
	IF EXISTS (SELECT * FROM CONTDIG_TSI1 WHERE ICARD = @cMatric)
	begin
	    SELECT @cTempl_Coa1tot = TEMPL_COA1,
		   @cTempl_Coa2tot = TEMPL_COA2,
		   @cTempl_Coa3tot = TEMPL_COA3,
		   @cTempl_Coa4tot = TEMPL_COA4,
		   @cTempl_Coa5aux = TEMPL_COA5
		FROM CONTDIG_TSI1
		WHERE ICARD = @cMatric

	    IF ((@cTempl_Coa1tot is Null) or (@cTempl_Coa2tot is Null) or 
			(@cTempl_Coa3tot is Null) or (@cTempl_Coa4tot is Null) or 
			(@cTempl_Coa5aux is Null) or
			(datalength(@cTempl_Coa1tot) < 160) or (datalength(@cTempl_Coa2tot) < 160) or
			(datalength(@cTempl_Coa3tot) < 160) or (datalength(@cTempl_Coa4tot) < 160) or 
			(datalength(@cTempl_Coa5Aux) < 128))
			SET @Coa = 0
	    else 
	    begin
			SET @cTempl_Coa5tot = @cTempl_Coa5aux + REPLICATE('0',160-LEN(@cTempl_Coa5aux) )
			SET @cTempl_Coa6tot = REPLICATE('0', 26)
	    end
	END

	IF (@Coa = 0) 
	begin
		Set @RetFun = 0
	end
	return (@Retfun)
END
GO

