DROP PROCEDURE sqlcon_veri_digital_tcpX
GO

CREATE PROCEDURE sqlcon_veri_digital_tcpX @cMatric char(12),
@cTempl_tit1tot CHAR(160) OUTPUT, @cTempl_tit2tot CHAR(160) OUTPUT, 
@cTempl_tit3tot CHAR(160) OUTPUT, @cTempl_tit4tot CHAR(160) OUTPUT, 
@cTempl_Alt1tot CHAR(160) OUTPUT, @cTempl_Alt2tot CHAR(160) OUTPUT, 
@cTempl_Alt3tot CHAR(160) OUTPUT, @cTempl_Alt4tot CHAR(160) OUTPUT,
@cNivel CHAR(1) OUTPUT, @cTempl_tit5tot CHAR(56) OUTPUT, @cTempl_Alt5tot CHAR(56) OUTPUT
AS

DECLARE @Retfun int, @Pad int, @Alt int

BEGIN
	--select @Retfun = -1
	select @Retfun = 3
	select @cTempl_tit1tot = NULL
	select @cTempl_tit2tot = NULL
	select @cTempl_tit3tot = NULL
	select @cTempl_tit4tot = NULL
	select @cTempl_tit5tot = NULL
	select @cTempl_Alt1tot = NULL
	select @cTempl_Alt2tot = NULL
	select @cTempl_Alt3tot = NULL
	select @cTempl_Alt4tot = NULL
	select @cTempl_Alt5tot = NULL
	select @cNivel = NULL
	-- procura por Templates da matricula
	IF EXISTS (SELECT * FROM CONTDIG_VERI WITH (Index = CONTDIG_VERI_IND1) WHERE ICARD = @cMatric)
	begin
	    SELECT @cTempl_tit1tot = TEMPL_TIT1,
		   @cTempl_tit2tot = TEMPL_TIT2,
		   @cTempl_tit3tot = TEMPL_TIT3,
		   @cTempl_tit4tot = TEMPL_TIT4,
		   @cTempl_Alt1tot = TEMPL_ALT1,
		   @cTempl_Alt2tot = TEMPL_ALT2,
		   @cTempl_Alt3tot = TEMPL_ALT3,
		   @cTempl_Alt4tot = TEMPL_ALT4,
		   @cNivel = NIVEL,
		   @cTempl_tit5tot = TEMPL_TIT5,
		   @cTempl_Alt5tot = TEMPL_ALT5
		FROM CONTDIG_VERI
		WHERE ICARD = @cMatric
	    select @Pad = 1    -- assume que tem template padrao
	    select @Alt = 1    -- assume que tem template alternativo
	    if ((@cTempl_tit1tot is Null) or (@cTempl_tit2tot is Null) or 
		(@cTempl_tit3tot is Null) or (@cTempl_tit4tot is Null) or
		(@cTempl_tit5tot is Null) or 
		(datalength(@cTempl_tit1tot) < 160) or 		(datalength(@cTempl_tit2tot) < 160) or
		(datalength(@cTempl_tit3tot) < 160) or 		(datalength(@cTempl_tit4tot) < 160) or
		(datalength(@cTempl_tit5tot) < 56)) 
	    begin
		SELECT @Pad = 0
	    end 
	    if ((@cTempl_Alt1tot is Null) or (@cTempl_Alt2tot is Null) or
		(@cTempl_Alt3tot is Null) or (@cTempl_Alt4tot is Null) or
		(@cTempl_Alt5tot is Null) or
		(datalength(@cTempl_Alt1tot) < 160) or 		(datalength(@cTempl_Alt2tot) < 160) or
		(datalength(@cTempl_Alt3tot) < 160) or 		(datalength(@cTempl_Alt4tot) < 160) or
		(datalength(@cTempl_Alt5tot) < 56)) 
	    begin 
		SELECT @Alt = 0
	    end
	    if (@Pad = 1) 
	    begin
	        if (@Alt = 1) 
		    select @Retfun = 0   -- tem padrao e tem alternativo
		else 
		    select @Retfun = 1   -- tem padrao e nao tem alternativo
	    end
	    if (@Pad = 0) 
	    begin
		if (@Alt = 1) 
		    select @Retfun = 2   -- nao tem padrao e tem alternativo
		else 
		    select @Retfun = 3   -- nao tem padrao e nao tem alternativo	
	    end
	END
	return (@Retfun)
END
GO

