DROP PROCEDURE sqller_comldig2 
GO
CREATE PROCEDURE sqller_comldig2 @cEndIp CHAR(15) AS

DECLARE @xCont smallint, @Ret smallint, @cStatus CHAR(1), @cBioTipo CHAR(1), @ERR INT, @cAux char(12)

	SET @xCont = 0
	SET @Ret = 0
	SET LOCK_TIMEOUT 2000

	SELECT @cStatus = STATUS, @cBioTipo = BIO_TIPO 
		from DIG002 NOLOCK where END_IP = @cEndIp;
	IF @@ROWCOUNT = 0 
		SET @Ret = 0
	ELSE
		IF (@cStatus = '1') BEGIN
			IF (@cBioTipo = '6' OR @cBioTipo = '7') BEGIN
				SELECT @cAux = ICARD
					FROM DIG001 NOLOCK
					WHERE    END_IP = @cEndIp AND
							STATUS != '0' AND
	            			STATUS != '2' 		-- nao seleciona status 2 para nao tentar carregar novamente a digital que ja deu errado na carga automatica

				set @xCont = @@ROWCOUNT
				if (@xCont = 0) begin
					-- indica em DIG002 que a lista foi carregada 
					UPDATE	DIG002 set STATUS = '0' where END_IP = @cEndIp;
					set @ERR = @@ERROR
					SET @Ret = 0
				end
				else begin
					UPDATE DIG002 set STATUS = '2',
										DATA_LOAD = getdate()  
					where END_IP = @cEndIp;
					set @ERR = @@ERROR
					SET @Ret = 1
				end
			END
			ELSE BEGIN
				IF (@cBioTipo = '8') BEGIN
					SELECT @cAux = ICARD
						FROM DIG003 NOLOCK
						WHERE    END_IP = @cEndIp AND
								STATUS != '0' AND
		            			STATUS != '2' 		-- nao seleciona status 2 para nao tentar carregar novamente a digital que ja deu errado na carga automatica

					set @xCont = @@ROWCOUNT
					if (@xCont = 0) begin
						-- indica em DIG002 que a lista foi carregada 
						UPDATE	DIG002 set STATUS = '0' where END_IP = @cEndIp;
						set @ERR = @@ERROR
						SET @Ret = 0
					end
					else begin
						UPDATE DIG002 set STATUS = '2',
											DATA_LOAD = getdate()  
						where END_IP = @cEndIp;
						set @ERR = @@ERROR
						SET @Ret = 2
					end
				END
			END
		END 
	SET LOCK_TIMEOUT -1
	SELECT @Ret
	GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON sqller_comldig2 TO ACE_USU
GO
