DROP PROCEDURE sqlavisa_cpbb_novell_tcp 
GO
CREATE PROCEDURE sqlavisa_cpbb_novell_tcp @pt_aviso char(250)
AS

DECLARE @Ret smallint, @cEndIp char(15), @cAviso char(2), @cStat char(1), @cMens char(30)

	set @Ret    = 0
	set @cEndIp = SUBSTRING(@pt_aviso,  1,15)
	set @cAviso = SUBSTRING(@pt_aviso, 16, 2)
	set @cStat  = SUBSTRING(@pt_aviso, 18, 1)
	set @cMens  = SUBSTRING(@pt_aviso, 19,30)
   
	UPDATE CP_BN SET ST = @cStat, EPN3 = @cMens 
		WHERE AVISO = @cAviso AND
			END_IP = @cEndIp and
			BLUEB = '00' and
			TERM = '00'
	
	IF (@@ROWCOUNT = 0) BEGIN
		-- aviso nao existe, sera' inserido novo comando
		INSERT INTO CP_BN (END_IP, AVISO, ST, EPN3) 
			VALUES (@cEndIp, @cAviso, @cStat, @cMens)
    END
              
	SELECT @Ret

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
