DROP PROCEDURE sqlat_tab_intj
GO
CREATE PROCEDURE sqlat_tab_intj @cRegistro1 char(100), @cRegistro2 char(100)
AS
DECLARE @Retorno int

DECLARE @cMatric char(12), @IniHA datetime, @FimHA datetime, @IniIJ datetime, @FimIJ datetime

	set @cMatric = substring(@cRegistro1, 1, 12)
	set @Retorno = 0
	set DATEFORMAT dmy
	SET @IniHA = CAST((substring(@cRegistro2,1,2)+'-'+
						 substring(@cRegistro2,3,2)+'-'+
						 substring(@cRegistro2,5,2)+' '+
						 substring(@cRegistro2,7,2)+':'+
						 substring(@cRegistro2,9,2)+':'+
						 substring(@cRegistro2,11,2)) AS datetime)

	SET @FimHA = CAST((substring(@cRegistro2,13,2)+'-'+
						 substring(@cRegistro2,15,2)+'-'+
						 substring(@cRegistro2,17,2)+' '+
						 substring(@cRegistro2,19,2)+':'+
						 substring(@cRegistro2,21,2)+':'+
						 substring(@cRegistro2,23,2)) AS datetime)

	SET @IniIJ = CAST((substring(@cRegistro2,25,2)+'-'+
						 substring(@cRegistro2,27,2)+'-'+
						 substring(@cRegistro2,29,2)+' '+
						 substring(@cRegistro2,31,2)+':'+
						 substring(@cRegistro2,33,2)+':'+
						 substring(@cRegistro2,35,2)) AS datetime)
	
	SET @FimIJ = CAST((substring(@cRegistro2,37,2)+'-'+
						 substring(@cRegistro2,39,2)+'-'+
						 substring(@cRegistro2,41,2)+' '+
						 substring(@cRegistro2,43,2)+':'+
						 substring(@cRegistro2,45,2)+':'+
						 substring(@cRegistro2,47,2)) AS datetime)
	
		
	IF EXISTS (SELECT ICARD FROM CONTROLE WITH (Index = CONTROLE_IND1) WHERE ICARD = @cMatric)
	begin
		UPDATE CONTROLE
		 set SITUA = substring(@cRegistro1, 13, 1),
		     SUBNV = substring(@cRegistro1, 14,5),
		     PLANTA = substring(@cRegistro1, 19,3),
		     ULTRS = substring(@cRegistro1, 22,25),
		     FX_DTA = substring(@cRegistro1, 47,11),
		     QTD_MENS = substring(@cRegistro1, 58, 2),
		     CRED_FX1 = substring(@cRegistro1, 60, 2),
		     CRED_FX2 = substring(@cRegistro1, 62, 2),
		     CRED_FX3 = substring(@cRegistro1, 64, 2),
		     CRED_FX4 = substring(@cRegistro1, 66, 2),
		     CRED_FX5 = substring(@cRegistro1, 68, 2),
		     CRED_FX6 = substring(@cRegistro1, 70, 2),
		     ULTPAS_REF = substring(@cRegistro1, 72, 10)
		WHERE ICARD = @cMatric
	end
	ELSE
	begin
		set @Retorno = -1
	end
	
	
	-- atualiza tab.DATAHORA
	IF EXISTS (SELECT ICARD FROM DATAHORA WHERE ICARD = @cMatric)
		UPDATE DATAHORA
			SET Ini_Halm = @IniHA,
				Fim_Halm = @FimHA,
				Ini_Intj = @IniIJ,
				Fim_Intj = @FimIJ
   	 	WHERE Icard = @cMatric
	ELSE
		INSERT INTO DATAHORA (Icard, Ini_Halm, Fim_Halm, Ini_Intj, Fim_Intj) 
      				  values (@cMatric, @IniHA, @FimHA, @IniIJ, @FimIJ);
	
	
	return @Retorno
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
