DROP PROCEDURE sqlatualiza_digital_tcp
GO
CREATE PROCEDURE sqlatualiza_digital_tcp @matric char(12), @templ1 char(160), @templ2 char(160), 
@templ3 char(160), @templ4 char(160), @nTipo char(1), @cNumDedo char(2), @cNivel char(1)
AS

DECLARE @cAuxMat char(15), @nRetorno int, @cAux char(1)

BEGIN
    select @nRetorno = 1
    IF NOT EXISTS (SELECT ICARD FROM CONTDIG WITH (Index = CONTDIG_IND1) WHERE ICARD = @matric)
    begin
	select @nRetorno = 0
    end
    IF (@nRetorno = 1)
    BEGIN
	IF (@nTipo = '0')
	BEGIN
	    UPDATE CONTDIG SET TEMPL_TIT1 = @templ1,
			       TEMPL_TIT2 = @templ2,
			       TEMPL_TIT3 = @templ3,
			       TEMPL_TIT4 = @templ4,
              		       NIVEL = @cNivel,
			       NUM_DEDO_PAD = @cNumDedo
	    WHERE ICARD = @matric
	END
	ELSE
	BEGIN
	    UPDATE CONTDIG SET TEMPL_ALT1 = @templ1,
			       TEMPL_ALT2 = @templ2,
			       TEMPL_ALT3 = @templ3,
			       TEMPL_ALT4 = @templ4,
              		       NIVEL = @cNivel,
			       NUM_DEDO_ALT = @cNumDedo
	    WHERE ICARD = @matric
	END
    END
    ELSE
    BEGIN
	IF (@nRetorno = 0)   -- matricula nao existe, sera inserido novo
	BEGIN
	    IF (@nTipo= '0')
	    BEGIN
		INSERT INTO CONTDIG (ICARD, TEMPL_TIT1, TEMPL_TIT2, TEMPL_TIT3, TEMPL_TIT4,
			      NIVEL, NUM_DEDO_PAD) 
		VALUES (@matric, @templ1, @templ2, @templ3, @templ4, @cNivel, @cNumDedo)
	    END
	    ELSE
	    BEGIN
		INSERT INTO CONTDIG (ICARD, TEMPL_ALT1, TEMPL_ALT2, TEMPL_ALT3, TEMPL_ALT4,
			      NIVEL, NUM_DEDO_ALT) 
		VALUES (@matric, @templ1, @templ2, @templ3, @templ4, @cNivel, @cNumDedo)
	    END
	END
    END
    return @nRetorno
END
GO

