DROP PROCEDURE sqlat_tab_datahora
GO
CREATE PROCEDURE sqlat_tab_datahora @cReg_dthora VARCHAR(250)
AS
DECLARE @Retorno SMALLINT

DECLARE @cMatric VARCHAR(12), @IniHA datetime, @FimHA datetime, @IniIJ datetime, @FimIJ datetime

	set @cMatric = substring(@cReg_dthora, 1, 12)
	set @Retorno = 0
	set DATEFORMAT dmy
	SET @IniHA = CAST((substring(@cReg_dthora,13,2)+'-'+
						 substring(@cReg_dthora,15,2)+'-'+
						 substring(@cReg_dthora,17,2)+' '+
						 substring(@cReg_dthora,19,2)+':'+
						 substring(@cReg_dthora,21,2)+':'+
						 substring(@cReg_dthora,23,2)) AS datetime);

	SET @FimHA = CAST((substring(@cReg_dthora,25,2)+'-'+
						 substring(@cReg_dthora,27,2)+'-'+
						 substring(@cReg_dthora,29,2)+' '+
						 substring(@cReg_dthora,31,2)+':'+
						 substring(@cReg_dthora,33,2)+':'+
						 substring(@cReg_dthora,35,2)) AS datetime);

	SET @IniIJ = CAST((substring(@cReg_dthora,37,2)+'-'+
						 substring(@cReg_dthora,39,2)+'-'+
						 substring(@cReg_dthora,41,2)+' '+
						 substring(@cReg_dthora,43,2)+':'+
						 substring(@cReg_dthora,45,2)+':'+
						 substring(@cReg_dthora,47,2)) AS datetime);
	
	SET @FimIJ = CAST((substring(@cReg_dthora,49,2)+'-'+
						 substring(@cReg_dthora,51,2)+'-'+
						 substring(@cReg_dthora,53,2)+' '+
						 substring(@cReg_dthora,55,2)+':'+
						 substring(@cReg_dthora,57,2)+':'+
						 substring(@cReg_dthora,59,2)) AS datetime);

	IF EXISTS (SELECT ICARD FROM DATAHORA  WHERE ICARD = @cMatric)
		UPDATE DATAHORA
			SET Ini_Halm = @IniHA,
				Fim_Halm = @FimHA,
				Ini_Intj = @IniIJ,
				Fim_Intj = @FimIJ
			WHERE Icard = @cMatric

	ELSE
		INSERT INTO DATAHORA (Icard, Ini_Halm, Fim_Halm, Ini_Intj, Fim_Intj) 
				  values (@cMatric, @IniHA, @FimHA, @IniIJ, @FimIJ);
	
	SELECT @Retorno as Retorno
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
