drop procedure prep_tsi1 
go
create PROCEDURE prep_tsi1 AS

DECLARE @c_status CHAR(1)
DECLARE @c_icard CHAR(12)

DECLARE @xc_status CHAR(1)
DECLARE @xc_icard CHAR(12)
DECLARE @xc_endip CHAR(15)
DECLARE @xc_tipobio CHAR(1)
DECLARE @ret CHAR(1)

DECLARE @z_endip CHAR(15)

SET DATEFORMAT YMD


	set @ret = 0

	-- cursor para matriculas cujas digitais foram alteradas
	DECLARE cur_stdigital CURSOR FOR (select ICARD, STATUS from CONTDIG_TSI1 WHERE STATUS = '1' or STATUS = '2')

	OPEN cur_stdigital
	FETCH NEXT FROM cur_stdigital INTO @c_icard, @c_status
	while @@fetch_status != -1
	begin
		if (@c_status = '2') begin
			-- apaga os icards que mudou de grupo de DIG003
			DELETE FROM DIG003 WHERE ICARD = @c_status
		end		

		-- MONTA temporaria matricula com codins com permissao acesso
		insert into TMP_DIG003 (ICARD, END_IP, STATUS, BIO_TIPO)
		select distinct @c_icard,  dat07.end_ip, '0', dat07.bio_tipo
			from dat07, dat08
			where
			  dat07.end_ip <> '000.000.000.000' and
			  dat08.grupo in (
				select grupo from CONTROLE where ICARD = @c_icard
				  union
				select grupo1 from CONTROLE where ICARD = @c_icard
				  union	
				select grupo2 from CONTROLE where ICARD = @c_icard
				  union
				select grupo3 from CONTROLE where ICARD = @c_icard
				  union
				select grupo_sab from CONTROLE where ICARD = @c_icard
				  union
				select grupo_dom from CONTROLE where ICARD = @c_icard
				  union
				select grupo_fer from CONTROLE where ICARD = @c_icard
			  ) AND 
			  dat07.laces = dat08.laces and
			  dat07.planta = dat08.planta and
			  (dat07.bio_tipo = '8') 

		-- verifica se a matricula esta cadastrada em controle e se pertence a alguma codin. 
		-- Caso negativo, seu status ainda continua setado at que seja cadastrada e pertena a algum local de acesso
		if (@@ROWCOUNT != 0) begin
			-- coloca o codin na tab. DIG002 (CARGA LISTA) o codin no existir
			insert into DIG002 (END_IP, DATA_LOAD, STATUS, BIO_TIPO)
				select distinct end_ip, getdate(), '0', bio_tipo  
				from
					tmp_dig003
				where
					end_ip not in ( select end_ip from DIG002 )

			-- insere icard-codin em tab. DIG001, se no existir em tab.
			DECLARE cur_tmpdigital CURSOR FOR (select ICARD, END_IP, STATUS, BIO_TIPO from TMP_DIG003)
			OPEN cur_tmpdigital
			FETCH NEXT FROM cur_tmpdigital into @xc_icard, @xc_endip, @xc_status, @xc_tipobio
			while @@fetch_status != -1
			begin
				UPDATE DIG003 SET STATUS = '1' 
					WHERE  ICARD = @xc_icard AND
						   END_IP = @xc_endip
				if @@rowcount = 0
				begin		
					INSERT INTO DIG003 (ICARD, END_IP, STATUS, BIO_TIPO) 
						values (@xc_icard, @xc_endip, '1', @xc_tipobio);
				end

				FETCH NEXT FROM cur_tmpdigital into @xc_icard, @xc_endip, @xc_status, @xc_tipobio
			end
			CLOSE cur_tmpdigital
			DEALLOCATE cur_tmpdigital
			DELETE TMP_DIG003

			-- atualiza status da matricula, como tratado
			update CONTDIG_TSI1 SET STATUS = 0 
				where ICARD =  @c_icard;
		end
		
		FETCH NEXT FROM cur_stdigital INTO @c_icard, @c_status
	end
	CLOSE cur_stdigital
	deallocate cur_stdigital

GO
